/*------------------------------------------------------------------------------*
 * File Name: OMatDlgDMC.h														*
 * Creation: GJL 2/20/03														*
 * Purpose: Origin C header file for OMatDlgDMC.c								*
 * Copyright (c) OriginLab Corp.	2003-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef _OMAT_DLG_DMC_H
#define _OMAT_DLG_DMC_H

// Needed resource ID From HelpID.h
#define IDD_DMC                         110

/**
		WKS.OGS calls this function to launch modeless DirectMatConvert dialog.
	Return:
		Returns TRUE on success and FALSE on failure.
*/
BOOL OnOpenDMC();

/**
		Dialog Builder calls this function immediately after the DirectMatConvert
		dialog is launched for initialization.
	Return:
		Returns TRUE.
*/
static BOOL OnInitDMC();

/**
		Dialog Builder calls this function when the GetSelectedRange toolbar button
		is clicked.
	Return:
		Returns DMC_NO_ERROR on success and DMC_WKS_SEL_ERROR on failure.
*/
static int OnClickUpdateRange();

/**
		Get the current selection range for the Direct Conversion to Matrix dialog box. 
	Example:
		See the OnInitDMC function for sample call.
	Parameters:
		bSelectAll=Returns entire worksheet/workbook as selection range if nothing is selected, default is FALSE
	Return:
		Returns DMC_NO_ERROR on success and DMC_WKS_SEL_ERROR on failure.
*/
static int GetSelectedRange( BOOL bSelectAll = FALSE );

/**
		Dialog Builder calls this function when the Convert push button is clicked.
	Parameters:
		ctrl=Push button control on DirectMatConvert dialog box 
	Return:
		Returns DMC_NO_ERROR on success and a DMC_ERROR code on failure.
*/
static int OnClickConvert(Control ctrl);

#endif // _OMAT_DLG_DMC_H